LibName user '';
/*
************************************************************************
*                                                                      *
*                  PROGRAM TITLE: fert_e.sas (SAS)                     *
*                                                                      *
*    Calculates exposure of all women 15-49 years of age during the    *
*            period 1-36 months preceeding the interview               *
*                                                                      *
*                based on chapter 3 of the DHS report.                 *
*      Guidelines October 30, 1994  - Version 5.0.1 of 10/05/95        *
*      Files:                                                          *
*           Input:  ccIRvvFL.DAT, women's file.                        *
*                   Variables used: V008 and V011.                     *
*           Output: Higher.SSD, Lower.SSD and Exposure.SSD             *
*                                                                      *
************************************************************************
*/

/* Tabulate exposure in current age group during the analysis period */
/*  and  write to file higher                                        */
Data Null;
     Set ccIRvvFL(Keep= V005 V008 V011);

     /* Period prior to the survey(<= 60 months) */
     period = 36;
     agem   = V008 - V011 - 1;
     age5   = Int(agem/60);

     /* Exposure in current age group */
     /* during the analysis period    */
     higexp = agem - (age5 * 60);
     If higexp > period Then higexp = period;

     /* Current age group */
     age5   = age5 - 3;
     higexp = higexp * V005/1000000;
     Proc Freq;
          Tables age5/Out=higher;
          Weight higexp;
          Title 'Exposure - High';
     Run;
Data Null;
     Set ccIRvvFL(Keep= V005 V008 V011);

     /* Period prior to the survey(<= 60 months) */
     period = 36;
     agem   = V008 - V011 - 1;
     age5   = Int(agem/60);
     higexp = agem - (age5 * 60) + 1;
     If higexp > period Then higexp = period;

     /* Current age-group  */
     age5   = age5 - 3;

     /* Previous age-group */
     age5   = age5 - 1;

     /* Exposure in previous age group */
     /*  during the analysis period    */
     lowexp = 0;
     If (higexp < period) & age5 >= 0 Then
       lowexp = period - higexp;
     lowexp = lowexp * V005/1000000;
     Proc Freq;
          Tables age5/Out=lower;
          Weight lowexp;
          Title 'Exposure - Low';
     Run;
Data Null;
     /* Merge exposure in current and previous age group and calculate*/
     /* total exposure in each age group. Write to file exposure      */
     Merge Higher(Rename=(count=higexp)) Lower(Rename=(count=lowexp));
         By age5;
     If higexp = . Then higexp = 0;
     If lowexp = . Then lowexp = 0;
     expos     = (higexp + lowexp)/12;
     Proc Print; Var age5 expos;
          Title 'Years of exposure';
     Run;
     Proc Freq;
          Tables age5/Out=exposure;
          Weight expos;
     Run;
