Data Null;
/*
************************************************************************
*                                                                      *
*                   PROGRAM TITLE: fert_b.sas (SAS)                    *
*                                                                      *
*        Calculates briths to women 15-49 during the period 1-36       *
*                  months preceeding the interview                     *
*                                                                      *
*               based on chapter 3 of the DHS report.                  *
*      Guidelines October 30, 1994  - Version 5.0.1 of 10/05/95        *
*                                                                      *
*      Input:  Child.SSD                                               *
*      Output: Births.SSD                                              *
*                                                                      *
************************************************************************
*/
     Set Child;

     /* Set period for the analysis. Program only works for periods */
     /* of 60 months or less.                                       */   
     period = 36;                   

     /* Calculate age at birth */ 
     age5 = Int((B3 - V011)/60) - 3; 
     rweight = V005/1000000;

     /* Tabulate births */
     If (0 < V008 - B3 <= period) & age5 >= 0;      
     Proc Freq;
          Tables age5/Out=Births;
          Weight rweight;
          Title 'Births';
     Run;
