Data Null;
/*
************************************************************************
*                                                                      *
*                  PROGRAM TITLE: Fert_a.sas (SAS)                     *
*                                                                      *
* Age specific fertility rates for all women 15-49 years of age during *
*         the period 1-36 months preceeding the interview.             *
*                                                                      *
*                based on chapter 3 of the DHS report.                 *
*      Guidelines October 30, 1994  - Version 5.0.1 of 10/05/95        *
*                                                                      *
************************************************************************
*/

     /* Merge births and exposure in each age group   */
     Merge Births(Rename=(count=chper)) Exposure(Rename=(count=expos));
         By age5;
     format asfr 8.2;
     format tfr  8.2;

     /* Calculate age-specific fertility rates and */
     /*  total fertility rate                      */
     asfr = chper * 1000/expos;
     tfr  = 5 * Sum(asfr,Lag1(asfr),Lag2(asfr),Lag3(asfr),
                         Lag4(asfr),Lag5(asfr),Lag6(asfr)) / 1000;
     If _N_^= 7 Then tfr = .;

     /* Label age groups */
     Proc Format;
          Value ages 0='15-19'
                     1='20-24'
                     2='25-29'   
                     3='30-34'
                     4='35-39'
                     5='40-44'
                     6='45-49';
     Run;

     /* Print births in each age group     */
     Proc PrintTo print='t301b.prt';
     Proc Print NoObs Split='*';
          Var age5 chper;
          Format age5 ages.;
          Label age5='Respondents* Age';
          Label chper='Number* of* births';
          Title 'Births to women 15-49';

     /* Print exposure by age group        */
     Proc PrintTo print='t301e.prt';
     Proc Print NoObs Split='*';
          Var age5 expos;
          Format age5 ages.;
          Label age5='Respondents* Age';
          Label expos='Years* of* Exposure';
          Title 'Exposure of women 15-49';

     /* Print age-specific fertility rates and TFR - final table */
     Proc PrintTo print='t301.prt';
     Proc Print NoObs Split='*';
          Var age5 asfr tfr;
          Format age5 ages.;
          Label age5='Respondents* Age';
          Label asfr='Age* Specific* Fertility* Rates';
          Title 'Age Specific and Total Fertility Rates for women 15-49 ';
     Run;
