/*
************************************************************************
*                                                                      *
*                PROGRAM TITLE: fert.sas (SAS)                         *
*                                                                      *
*                     FERTILITY rates                                  *
*                                                                      *
* SAS file is based on data related to children. The variables used    *
* in this program are:                                                 *
*                                                                      *
*           Mother:  V005, V008, V011                                  *
*           Child:   B3                                                *
*  Extract these variables from the distributed SAS description file.  *
*                                                                      *
* mafl.sas: Subset of the SAS description of the distributed data file.*
*                                                                      *
*          It contains the description of V005, V008, V011             *
*                                         B3.                          *
*                                                                      *
* Tables produced:                                                     *
*           t301b.prt: Births.                                         *
*           t301e.prt: Exposure.                                       *
*           t301 .prt: Age Specific and Total Fertility Rates.         *
*                                                                      *
************************************************************************
*/
%Inc 'sasfl.sas';     /* SAS Description of the variables used */
%Inc 'fert_f.sas';    /* Creates a child file */
%Inc 'fert_b.sas';    /* Produces the distribution of births to women 15-49 */
%Inc 'fert_e.sas';    /* Exposure of women 15-49 */
%Inc 'fert_a.sas';    /* Produces Age Specific and Total Fertility Rates */
